{
                                                                   
   VCL component TDatelbl                                           
                                                                   
   Label to display date and current time of day                    
                                                                    
    Created by Fred Irving                                           
    on 10 Nov 2002 at 21:14                                         
                                                                    
   Copyright  2006 MaxFx Software                                      
                                                                    
   http://www.maxfx.tv                                          
} 


unit Datelbl;

interface

uses Classes, Controls, ExtCtrls, Forms, Graphics, Messages, 
     Stdctrls, SysUtils, WinProcs, WinTypes;

type
  TDatelbl = class(TCustomLabel)
    private
      { Private fields of TDatelbl }
        { Storage for property DateFmtUK }
        FDateFmtUK : Boolean;
        { Storage for property DateStr }
        FDateStr : String;
        { Storage for property ShowDate }
        FShowDate : Boolean;
        { Storage for property ShowTime }
        FShowTime : Boolean;
        { Storage for property TimeFmt24hr }
        FTimeFmt24hr : Boolean;
        { Storage for property TimeSep }
        FTimeSep : String;
        { Storage for property TimeStr }
        FTimeStr : String;
        { Internal timer for updating time display }
        Timer : TTimer;

      { Private methods of TDatelbl }
        { Method to set variable and property values and create objects }
        procedure AutoInitialize;
        { Method to free any objects created by AutoInitialize }
        procedure AutoDestroy;
        { Write method for property DateFmtUK }
        procedure SetDateFmtUK(Value : Boolean);
        { Read method for property DateStr }
        function GetDateStr : String;
        { Write method for property ShowDate }
        procedure SetShowDate(Value : Boolean);
        { Write method for property ShowTime }
        procedure SetShowTime(Value : Boolean);
        { Write method for property TimeFmt24hr }
        procedure SetTimeFmt24hr(Value : Boolean);
        { Write method for property TimeSep }
        procedure SetTimeSep(Value : String);
        { Read method for property TimeStr }
        function GetTimeStr : String;
        { Returns updated time and date string }
        function NewCaption : String;
        { Forces update to label; triggered by Timer's OnTimer events }
        procedure Update(Sender : TObject);

    protected
      { Protected fields of TDatelbl }

      { Protected methods of TDatelbl }
        procedure Paint; override;

    public
      { Public fields and properties of TDatelbl }
        { Current date }
        property DateStr : String read GetDateStr;
        { Current time }
        property TimeStr : String read GetTimeStr;

      { Public methods of TDatelbl }
        constructor Create(AOwner: TComponent); override;
        destructor Destroy; override;

    published
      { Published properties of TDatelbl }
        { Uk Date (dd/mmm/yyy)? }
        property DateFmtUK : Boolean
             read FDateFmtUK write SetDateFmtUK
             default True;
        { Publish Font property of parent class }
        property Font;
        { Include date in display? }
        property ShowDate : Boolean
             read FShowDate write SetShowDate
             default True;
        { Include time in display? }
        property ShowTime : Boolean
             read FShowTime write SetShowTime
             default True;
        { Display 24-hour time or 12-hour? }
        property TimeFmt24hr : Boolean
             read FTimeFmt24hr write SetTimeFmt24hr
             default True;
        { Field separator for time string }
        property TimeSep : String read FTimeSep write SetTimeSep;
        { Transparent background }
        property Transparent default False;
        { Publish Visible property of parent class }
        property Visible default True;

  end;

procedure Register;

implementation

procedure Register;
begin
     { Register TDatelbl with Irvsoft as its
       default page on the Delphi component palette }
     RegisterComponents('Irvsoft', [TDatelbl]);
end;

{ Method to set variable and property values and create objects }
procedure TDatelbl.AutoInitialize;
begin
     Timer := TTimer.Create(Self);
     with Timer do
          begin
          { Trigger OnTimer events every 30 seconds }
          Interval := 30000;
          { OnTimer events will generate call to Update procedure }
          OnTimer := Update;
          end;
     FDateFmtUK := True;
     FShowDate := True;
     FShowTime := True;
     FTimeFmt24hr := True;
     FTimeSep := ':';
     Transparent := False;
     Visible := True;
end; { of AutoInitialize }

{ Method to free any objects created by AutoInitialize }
procedure TDatelbl.AutoDestroy;
begin
     Timer.Free;
end; { of AutoDestroy }

{ Write method for property DateFmtUK }
procedure TDatelbl.SetDateFmtUK(Value : Boolean);
begin
     FDateFmtUK := Value;

     { If changing this property affects the appearance of
       the component, call Invalidate here so the image will be
       updated. }
     { Invalidate; }
end;

{ Read method for property DateStr }
function TDatelbl.GetDateStr : String;
const
     Months : array[1..12] of String[10] =
              ('January','February','March','April','May','June',
              'July','August','September','October','November','December');
 var
     Year, Month, Day, Weekday : Word;
     DayStr, YearStr : String[10];
begin
     (*  Obtain the date information  *)
     DecodeDate(Now, Year, Month, Day);
     Str(Day, DayStr);
     Str(Year, YearStr);
     if FDateFmtUK then
     FDateStr := DayStr + ' ' + Months[Month] + ' ' + YearStr
     else
     FDateStr := Months[Month] + ' ' + DayStr + ', ' + YearStr;
     GetDateStr := FDateStr
end;

{ Write method for property ShowDate }
procedure TDatelbl.SetShowDate(Value : Boolean);
begin
     FShowDate := Value;
     { Changing this value changes the display, so ... }
     Invalidate;
end;

{ Write method for property ShowTime }
procedure TDatelbl.SetShowTime(Value : Boolean);
begin
     FShowTime := Value;
     { Changing this value changes the display, so ... }
     Invalidate;
end;

{ Write method for property TimeFmt24hr }
procedure TDatelbl.SetTimeFmt24hr(Value : Boolean);
begin
     FTimeFmt24hr := Value;
     Invalidate
end;

{ Write method for property TimeSep }
procedure TDatelbl.SetTimeSep(Value : String);
begin
     FTimeSep := Value;
     { Changing this value changes the display, so ... }
     Invalidate;
end;

{ Read method for property TimeStr }
function TDatelbl.GetTimeStr : String;
 var
     Hour, Minute, Seconds, Hundreds : Word;
     HourStr, MinuteStr, AmPm : String[10];
begin
     (*  Obtain the time information  *)
     DecodeTime(Now, Hour, Minute, Seconds, Hundreds);
     (*  Take account of 12-hour time, if necessary  *)
     if FTimeFmt24hr then
          AmPm := ''
     else
          if Hour > 12 then
               begin
               Hour := Hour - 12;
               AmPm := ' pm'
               end
          else
               AmPm := ' am';
     (*  Convert the time values to strings  *)
     Str(Hour, HourStr);
     Str(Minute, MinuteStr);
     (*  Add leading zero if Minute is one digit  *)
     if Minute < 10 then
          MinuteStr := '0' + MinuteStr;
     FTimeStr := HourStr + FTimeSep + MinuteStr + AmPm;
     GetTimeStr := FTimeStr
end;

constructor TDatelbl.Create(AOwner: TComponent);
begin
     { Call the Create method of the parent class }
     inherited Create(AOwner);

     { Set the initial values of variables and properties and }
     { create object for Timer variable. }
     { AutoInitialize procedure is generated by Component Create. }
     AutoInitialize;

     { Start timer }
     Timer.Enabled := True
end;

destructor TDatelbl.Destroy;
begin
     { AutoDestroy, which is generated by Component Create, frees any   }
     { objects created by AutoInitialize.                               }
     AutoDestroy;

     { Free the component by calling the Destroy method of the          }
     { parent class.                                                    }
     inherited Destroy;
end;

{ Returns updated time and date string }
function TDatelbl.NewCaption : String;
var
     DisplayLine : String;
begin
     if FShowDate then
          DisplayLine := GetDateStr
     else
          DisplayLine := '';
     if FShowDate and FShowTime then
          DisplayLine := DisplayLine + '  ';
     if FShowTime then
          DisplayLine := DisplayLine + GetTimeStr;
     NewCaption := DisplayLine
end;

procedure TDatelbl.Paint;
begin
     { Update the caption of the label with the current date
       and time string, then call the Paint method of the
       parent class to re-draw }
     Caption := NewCaption;
     inherited Paint;
end;

{ Forces update to label; triggered by Timer's OnTimer events }
procedure TDatelbl.Update(Sender : TObject);
{ The component calls Update method periodically to keep
  the time display current.  Update has been declared with
  one argument of type TObject so it can be assigned as the
  OnTimer event handler for variable Timer. }

begin
     { Has the time and date display changed?  If so, re-draw }
     if NewCaption <> Caption then
        Invalidate
end;


end.
